<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'admin_panel/db.php'; // Include your database connection

try {
    // Fetch users with status 0
    $usersSql = "SELECT * FROM telegram_users"; // Fetch all users
    $usersResult = $conn->query($usersSql);

    if ($usersResult->num_rows > 0) {
        // Fetch all bot tokens from the database
        $tokensSql = "SELECT token FROM telegram_bot_tokens"; // Assuming bot tokens are stored
        $tokensResult = $conn->query($tokensSql);

        // Check if bot tokens are found
        if ($tokensResult->num_rows > 0) {
            // Loop through all users
            $users = [];
            while ($user = $usersResult->fetch_assoc()) {
                $users[] = $user; // Store all users in an array
            }

            // Initialize bot index
            $botIndex = 0;
            $totalBots = $tokensResult->num_rows;

            // Fetch default global settings
            $defaultSettingsQuery = "SELECT * FROM global_message_settings WHERE id = 1";
            $defaultSettingsResult = $conn->query($defaultSettingsQuery);
            $defaultSettings = $defaultSettingsResult->num_rows > 0 ? $defaultSettingsResult->fetch_assoc() : [];

            // Loop through users
            foreach ($users as $user) {
                $chatId = $user['chat_id']; // User's Telegram chat ID

                // Fetch user-specific settings
                $userSettingsQuery = "SELECT * FROM user_category_message_settings WHERE user_id = '{$user['id']}'";
                $userSettingsResult = $conn->query($userSettingsQuery);

                // Determine settings to use
                if ($userSettingsResult->num_rows > 0) {
                    $settings = $userSettingsResult->fetch_assoc();
                } else {
                    $settings = $defaultSettings; // Use default settings if user-specific settings are not found
                }

                // Extract settings values
                $selectedCategories = !empty($settings['category_name']) ? explode(',', $settings['category_name']) : [];
                $debtPaymentExpiryPeriod = $settings['debt_payment_expiry_period'] ?? 0;
                $messagePrompt = $settings['message_prompt'] ?? '';
                $notificationTime = $settings['notification_send_time'] ?? '';

                // Check if the notification time has passed
                if (time() >= strtotime($notificationTime)) {
                    // Get the bot token
                    $tokensResult->data_seek($botIndex); // Move to the current bot
                    $bot = $tokensResult->fetch_assoc();
                    $botToken = $bot['token'];

                    // Create the message
                    $fullMessage = "Hello! 👋\n\n";
                    $fullMessage .= "Your debt payment is due in: " . $debtPaymentExpiryPeriod . " days.\n\n";
                    $fullMessage .= "Message: " . $messagePrompt . "\n\n";
                    if (!empty($selectedCategories)) {
                        $fullMessage .= "Categories: " . implode(', ', $selectedCategories) . "\n\n";
                    }
                    $fullMessage .= "Thank you for your attention. If you have any questions, feel free to contact us.\n\n";
                    $fullMessage .= "Best regards,\nYour Support Team";

                    // Send the message
                    $messageSent = sendMessageToTelegramByChatId($botToken, $chatId, $fullMessage);

                    // Log the message status
                    logMessageStatus($conn, $chatId, $botToken, $fullMessage, $messageSent);

                    // Update the bot index
                    $botIndex = ($botIndex + 1) % $totalBots; // Loop back after the last bot

                    // Delay to prevent spamming
                    sleep(1);
                }
            }
        } else {
            echo "No bot tokens found in the database.\n";
        }
    } else {
        echo "No users found in the database.\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

// Functions remain unchanged

function sendMessageToTelegramByChatId($botToken, $chatId, $message) {
    $url = "https://api.telegram.org/bot" . $botToken . "/sendMessage";
    $data = ['chat_id' => $chatId, 'text' => $message];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return $httpCode === 200;
}

function logMessageStatus($conn, $chatId, $botToken, $message, $messageSent) {
    $status = $messageSent ? 'sent' : 'failed';

    // Check if a log already exists for this chat ID and bot token
    $checkSql = "SELECT id FROM message_logs WHERE chat_id = '$chatId' AND bot_token = '$botToken'";
    $checkResult = $conn->query($checkSql);

    if ($checkResult->num_rows > 0) {
        // Update the existing log
        $updateSql = "UPDATE message_logs 
                      SET message = '$message', status = '$status', timestamp = NOW() 
                      WHERE chat_id = '$chatId' AND bot_token = '$botToken'";
        $conn->query($updateSql);
    } else {
        // Insert a new log if no existing log is found
        $insertSql = "INSERT INTO message_logs (chat_id, bot_token, message, status, timestamp) 
                      VALUES ('$chatId', '$botToken', '$message', '$status', NOW())";
        $conn->query($insertSql);
    }
}
?>