<?php
ob_start(); // Start output buffering
session_start();

include "db.php"; 
include "commen.php"; 

// Pagination settings
$limit = 10; // Number of records per page
$offset = 0; // Offset to fetch data for the current page

// Get the current page from query parameter, default to 1 if not set
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search query
$search = isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; // Fetch and sanitize search term

// Fetch users with pagination and search
$sql = "SELECT * FROM telegram_users WHERE first_name LIKE ? ORDER BY id DESC LIMIT ?, ?";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $search_term = '%' . $search . '%';
    $stmt->bind_param("sii", $search_term, $offset, $limit);
    $stmt->execute();
    $result = $stmt->get_result();

    // Fetch data
    $data = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
} else {
    die("Error preparing statement: " . $conn->error);
}

// Fetch total records for pagination
$total_sql = "SELECT COUNT(*) FROM telegram_users WHERE first_name LIKE ?";
$total_stmt = $conn->prepare($total_sql);
if ($total_stmt) {
    $total_stmt->bind_param("s", $search_term);
    $total_stmt->execute();
    $total_result = $total_stmt->get_result();
    $total_rows = $total_result->fetch_row()[0];
    $total_stmt->close();
} else {
    die("Error preparing statement: " . $conn->error);
}

// Calculate total pages
$total_pages = ceil($total_rows / $limit);

// Handle deletion if delete_id is set
if (isset($_GET['delete_id']) && is_numeric($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    $delete_sql = "DELETE FROM telegram_users WHERE id = ?";
    $delete_stmt = $conn->prepare($delete_sql);

    if ($delete_stmt) {
        $delete_stmt->bind_param("i", $delete_id);
        if ($delete_stmt->execute()) {
            header("Location: " . $_SERVER['PHP_SELF'] . "?search=" . urlencode($search) . "&page=" . $page);
            exit();
        } else {
            echo "Error deleting user: " . $delete_stmt->error;
        }
        $delete_stmt->close();
    } else {
        die("Error preparing statement: " . $conn->error);
    }
}
?>

<div class="content" id="dynamic-content">
    <h2>Telegram Users List</h2>
    <a href="add_user.php"><button class="btn btn-primary">Add User</button></a>
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>No.</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Chat ID</th>
                    <th>Username</th>
                    <th>PhoneNumber</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody id="table-body">
                <?php
                $count = $offset + 1; // Start counting from the correct record
                foreach ($data as $user) {
                ?>
                    <tr>
                        <td><?php echo $count++; ?></td>
                        <td><?php echo $user['first_name']; ?></td>
                        <td><?php echo $user['last_name']; ?></td>
                        <td><?php echo $user['chat_id']; ?></td>
                        <td><?php echo $user['username']; ?></td>
                        <td><?php echo $user['phonenumber']; ?></td>
                        <td><?php echo $user['date']; ?></td>
                        <td>
                            <a href="user_settings.php?user_id=<?php echo $user['id']; ?>"><button class="btn btn-primary">Settings</button></a>
                            <a href="add_user.php?edit_id=<?php echo $user['id']; ?>"><button class="btn btn-primary">Edit</button></a>
                            <a href="javascript:void(0);" onclick="confirmDelete(<?php echo $user['id']; ?>)"><button class="btn btn-danger">Delete</button></a>
                        </td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination buttons -->
    <div id="pagination" class="d-flex justify-content-center">
        <?php
        if ($page > 1) {
            echo '<a href="?page=' . ($page - 1) . '&search=' . urlencode($search) . '" class="btn btn-primary">Previous</a>';
        }

        for ($i = 1; $i <= $total_pages; $i++) {
            echo '<a href="?page=' . $i . '&search=' . urlencode($search) . '" class="btn btn-primary">' . $i . '</a>';
        }

        if ($page < $total_pages) {
            echo '<a href="?page=' . ($page + 1) . '&search=' . urlencode($search) . '" class="btn btn-primary">Next</a>';
        }
        ?>
    </div>
</div>

<script>
function confirmDelete(deleteId) {
    if (confirm('Are you sure you want to delete this user?')) {
        // Redirect to delete user with the selected id
        window.location.href = "?delete_id=" + deleteId;
    }
}
</script>