<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include "db.php";
date_default_timezone_set('Asia/Kuala_Lumpur');
if (isset($_REQUEST['userid']) && $_REQUEST['userid'] != '') {
    $user_id = $_REQUEST['userid'];

    // Check if the user exists
    $check_query = "SELECT * FROM telegram_users WHERE id = ?";
    $stmt = $conn->prepare($check_query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Update existing record with the current date and time
        $update_query = "UPDATE telegram_users 
                                    SET notification_msg_send_update_time = NOW()
                                    WHERE id = ?";
        $stmt = $conn->prepare($update_query);
        $stmt->bind_param("i", $user_id);

        if ($stmt->execute()) {
            $message = "User updated successfully!";
            $message_class = "alert-success";
            writeNotificationLog($user_id, "Msg Send successfully."); // Write to notification log
        } else {
            $message = "Error updating settings: " . $stmt->error;
            $message_class = "alert-danger";
            writeNotificationLog($user_id, "Error updating user: " . $stmt->error, "failed"); //write to notification log with error
        }
    } else {
        $message = "User not found!";
        $message_class = "alert-warning";
    }
} else {
    $message = "User ID is missing!";
    $message_class = "alert-danger";
}

// Function to write notification log to file
function writeNotificationLog($userId, $message, $status = "success") {
    $logFile = 'notification_update_log.txt';
    $logMessage = date('Y-m-d H:i:s') . " - User ID: " . $userId . " - Status: " . $status . " - " . $message . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>User Notification Details</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="message_show" style="text-align: center; margin: 40px;">
        <h1 class="<?php echo $message_class; ?>"><?php echo $message; ?></h1>
    </div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>