<?php
require 'db.php'; // Include your database connection file

function processCSV($file) {
    global $conn; // Use the existing database connection

    $success = 0;
    $fail = 0;

    if (($handle = fopen($file, "r")) !== FALSE) {
        fgetcsv($handle); // Skip header row
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $first_name = $data[0];
            $last_name = $data[1];
            $chat_id = $data[2];
            $phone = $data[3];

            $sql = "INSERT INTO telegram_users (first_name, last_name, chat_id, phonenumber) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("ssss", $first_name, $last_name, $chat_id, $phone);
                if ($stmt->execute()) {
                    $success++;
                } else {
                    $fail++;
                }
                $stmt->close();
            } else {
                $fail++;
            }
        }
        fclose($handle);
    }

    return [$success, $fail];
}
?>