<?php

include __DIR__ . '/db.php'; // Make sure your database connection is included here

$curl = curl_init();

// Fetch the last update ID to use as offset for the next request
$last_update_id = 0; // Initialize with zero or last known update ID if stored

curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.telegram.org/bot8187045022:AAEk6sJawXf8v_6Uh7Z3QN1_flS6B_mrVtI/getUpdates?offset=$last_update_id",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);
$response_data = json_decode($response, true);
curl_close($curl);

// Check if response has data
if (isset($response_data['result']) && count($response_data['result']) > 0) {
    foreach ($response_data['result'] as $update) {
       
        // Extract first name, last name, chat ID, and message text
        $firstName = isset($update['message']['from']['first_name']) ? $update['message']['from']['first_name'] : 'N/A';
        $lastName = isset($update['message']['from']['last_name']) ? $update['message']['from']['last_name'] : 'N/A';
        $chatId = isset($update['message']['chat']['id']) ? $update['message']['chat']['id'] : 'N/A';
        $messageText = isset($update['message']['text']) ? $update['message']['text'] : '';

        // Update the offset with the last processed message ID
        $last_update_id = $update['update_id'] + 1;

        // Check if the message contains the /start command
        if (strpos($messageText, '/start') !== false) {
            // Check if the chat_id already exists in the database
            $stmt = $conn->prepare("SELECT COUNT(*) FROM telegram_users WHERE chat_id = ?");
            $stmt->bind_param("s", $chatId);
            $stmt->execute();
            $stmt->bind_result($count);
            $stmt->fetch();
            $stmt->close();

            if ($count == 0) {
                // Insert new data if chat_id does not exist
                $stmt = $conn->prepare("INSERT INTO telegram_users (first_name, last_name, chat_id) VALUES (?, ?, ?)");
                $stmt->bind_param("sss", $firstName, $lastName, $chatId);

                if ($stmt->execute()) {
                    echo "Data inserted successfully: $firstName $lastName, Chat ID: $chatId\n";
                } else {
                    echo "Error inserting data: " . $stmt->error . "\n";
                }
                $stmt->close();
                
                // Send the message when the /start command is detected
                $message = "Welcome to our loan service! Please choose an option:";
                $keyboard = [
                    'inline_keyboard' => [
                        [
                            ['text' => '📊 *Borrow a Loan*', 'callback_data' => 'borrow'],
                        ],
                        [
                            ['text' => '💳 *Repay the Loan*', 'callback_data' => 'repay'],
                        ],
                        [
                            ['text' => '📜 *View History (Remaining)*', 'callback_data' => 'history'],
                        ]
                    ]
                ];


                // Call sendMessage function from sendMessage.php
                sendMessage($chatId, $message, $keyboard);
                   
            } else {
                echo "Chat ID already exists: $chatId\n";
            }
        }
    }
} else {
    echo "No new messages found.\n";
}

// Close database connection
$conn->close();

// Function to send message
function sendMessage($chatId, $message, $keyboard = null) {
    $botToken = "8187045022:AAEk6sJawXf8v_6Uh7Z3QN1_flS6B_mrVtI"; // Replace with your bot's token
    $url = "https://api.telegram.org/bot$botToken/sendMessage";

    // Prepare the data
    $data = [
        'chat_id' => $chatId,
        'text' => $message
    ];

    // If a keyboard is passed, add it to the message
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }

    // Use cURL to send the request
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data)); // URL encode the data
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);

    // Log the response for debugging
    if ($response === false) {
        $error = curl_error($ch);
        echo "Error: $error";
        curl_close($ch);
        return false;
    }

    curl_close($ch);
    
    // Log the response to see what Telegram returns
    $response_data = json_decode($response, true);
    if (isset($response_data['ok']) && $response_data['ok'] === true) {
        echo "Message sent successfully!\n";
    } else {
        echo "Failed to send message. Response: " . print_r($response_data, true) . "\n";
    }

    return true;
}
?>