<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include "db.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Responsive Admin Panel</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <!-- jQuery and Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-Fy6S3B9q64WdZWQUiU+q4/2Lc9npb8tCaSX9FK7E8HnRr0Jz8D6OP9dO5Vg3Q9ct" crossorigin="anonymous"></script>
    <style>
        /* Sidebar styling */
        .sidebar {
            height: 100vh;
            width: 250px;
            background-color: #343a40;
            color: #fff;
            position: fixed;
            top: 0;
            left: 0;
            transition: all 0.3s;
            z-index: 10;
        }
        .sidebar ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar ul li {
            padding: 15px;
            border-bottom: 1px solid #495057;
            cursor: pointer;
        }
        .sidebar ul li a{
            color:white;
            text-decoration:none;
        }
        .sidebar ul li:hover {
            background-color: #495057;
        }
        .sidebar.closed {
            width: 0;
            overflow: hidden;
        }
        .content {
            margin-left: 250px;
            transition: all 0.3s;
            padding: 10px;
        }
        .content.full-width {
            margin-left: 0;
        }
        
        .message-container {
            max-height: 100px; /* Set a max height for the message container */
            overflow-y: auto; /* Add vertical scrolling if content exceeds the max height */
            margin-bottom: 15px; /* Spacing below the message */
            padding: 10px;
            background-color: #f8f9fa; /* Light background for better readability */
            border: 1px solid #ddd; /* Light border for contrast */
            border-radius: 5px;
        }
        
        .message-container p {
            margin: 0; /* Remove default margin for the paragraph inside the container */
        }


        /* Mobile responsiveness */
        @media (max-width: 768px) {
            .sidebar {
                width: 0;
                overflow: hidden;
            }
            .sidebar.open {
                width: 250px;
            }
            .content {
                margin-left: 0;
            }
            .content.shifted {
                margin-left: 250px;
            }
        }
    </style>
</head>
<body>
    <div class="sidebar" id="sidebar">
            <button class="btn btn-secondary mt-3" id="translate-btn">切换语言</button>
            <br>
    <!--<div class="nav-item"><a href="index.php">Users List</a></div>-->
    <ul>
    <!--<li><a href="bot_accountlist.php">Bot Account List</a></li>-->
            <li><a href="telegram_userslist.php">User Account List</a></li>
            <!--<li><a href="scheduled_messages.php">Scheduled Messages</a></li>-->
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
</ul>
<style>
    .sidebar {
        height: 100vh;
        width: 250px;
        background-color: #343a40;
        color: #fff;
        position: fixed;
        top: 0;
        left: 0;
        transition: all 0.3s;
        z-index: 10;
    }
    .nav-item {
        padding: 15px;
        border-bottom: 1px solid #495057;
        cursor: pointer;
    }
    .nav-item a {
        color: white;
        text-decoration: none;
        display: block;
    }
    .nav-item:hover {
        background-color: #495057;
    }
    .sidebar.closed {
        width: 0;
        overflow: hidden;
    }
</style>

    </div>
    <div class="content" id="content">
        <button class="btn btn-primary mt-3" id="toggle-btn">Toggle</button>
        
    </div>

    <!-- Sidebar Toggle Script -->
    <script>
    
        const toggleBtn = document.getElementById("toggle-btn");
        const sidebar = document.getElementById("sidebar");
        const content = document.getElementById("content");

        toggleBtn.addEventListener("click", () => {
            if (window.innerWidth <= 768) {
                sidebar.classList.toggle("open");
                content.classList.toggle("shifted");
            } else {
                sidebar.classList.toggle("closed");
                content.classList.toggle("full-width");
            }
        });
    </script>
    <script>
document.addEventListener("DOMContentLoaded", function () {
    const translateBtn = document.getElementById("translate-btn");
    let currentLang = localStorage.getItem("lang") || "en";
    const originalTexts = new Map();

    function saveOriginalText() {
    const elements = document.querySelectorAll("*:not(script):not(style):not(meta):not(link):not(input):not(textarea):not([data-no-translate])");
    elements.forEach(el => {
        if (el.childNodes.length === 1 && el.childNodes[0].nodeType === 3) {
            if (!originalTexts.has(el)) {
                originalTexts.set(el, el.textContent.trim());
            }
        }
    });
}


    function restoreOriginalText() {
        originalTexts.forEach((text, el) => {
            el.textContent = text;
        });
    }

    function translatePage(targetLang) {
        if (targetLang === "en") {
            restoreOriginalText();
            localStorage.setItem("lang", "en");
            return;
        }

        const textNodes = [...originalTexts.keys()];
        const textArray = textNodes.map(node => originalTexts.get(node));

        if (textArray.length === 0) return;

        const googleTranslateURL = `https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=${targetLang}&dt=t&q=${encodeURIComponent(textArray.join("\n"))}`;

        fetch(googleTranslateURL)
            .then(response => response.json())
            .then(data => {
                const translatedTexts = data[0].map(item => item[0]);
                textNodes.forEach((node, index) => {
                    node.textContent = translatedTexts[index];
                });

                localStorage.setItem("lang", targetLang);
            })
            .catch(error => console.error("Translation Error:", error));
    }

    saveOriginalText();

    translateBtn.addEventListener("click", function () {
        currentLang = currentLang === "en" ? "zh" : "en";
        translatePage(currentLang);
    });

    if (currentLang !== "en") {
        translatePage(currentLang);
    }

    // Observe changes in dynamic content
    const observer = new MutationObserver(() => {
        saveOriginalText();
        if (currentLang !== "en") {
            translatePage(currentLang);
        }
    });

    observer.observe(document.getElementById("dynamic-content"), { childList: true, subtree: true });
});
</script>


</body>
</html>
